/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.shapedata;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.shapedata.ContainerShapedata;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.data.RelativeShape;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.item.datacard.ShapeCard;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileShapedata
extends TileBlockEntityCyclic
implements MenuProvider {
    private static final int SLOT_A = 0;
    private static final int SLOT_B = 1;
    private static final int SLOT_CARD = 2;
    ItemStackHandler inventory = new ItemStackHandler(3){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0 || slot == 1) {
                return stack.m_41720_() instanceof LocationGpsCard;
            }
            return stack.m_41720_() instanceof ShapeCard;
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private RelativeShape copiedShape;
    private int hasStashIfOne;

    public void execute(StructCommands cmd) {
        ItemStack shapeCard = this.inventory.getStackInSlot(2);
        if (!(shapeCard.m_41720_() instanceof ShapeCard)) {
            return;
        }
        RelativeShape cardShape = RelativeShape.read(shapeCard);
        switch (cmd) {
            case READ: {
                BlockPos invA = this.getTarget(0);
                BlockPos invB = this.getTarget(1);
                if (invA == null || invB == null) break;
                List<BlockPos> shape = UtilShape.rect(invA, invB);
                RelativeShape worldShape = new RelativeShape(this.f_58857_, shape, this.f_58858_);
                worldShape.write(shapeCard);
                break;
            }
            case COPY: {
                this.copiedShape = new RelativeShape(cardShape);
                break;
            }
            case PASTE: {
                if (this.copiedShape == null || shapeCard.m_41783_() == null) break;
                shapeCard.m_41751_(null);
                this.copiedShape.write(shapeCard);
                ModCyclic.LOGGER.info(cmd + " success");
                break;
            }
            case MERGE: {
                if (this.copiedShape == null || cardShape.getShape().size() <= 0) break;
                cardShape.merge(this.copiedShape);
                cardShape.write(shapeCard);
                ModCyclic.LOGGER.info(cmd + " success");
            }
        }
    }

    public TileShapedata(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.COMPUTER_SHAPE.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileShapedata e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileShapedata e) {
        e.tick();
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerShapedata(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        if (tag.m_128441_("copiedShape")) {
            CompoundTag cs = (CompoundTag)tag.m_128423_("copiedShape");
            this.copiedShape = RelativeShape.read(cs);
        }
        this.hasStashIfOne = tag.m_128451_("stashToggle");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("stashToggle", this.hasStashIfOne);
        if (this.copiedShape != null) {
            CompoundTag copiedShapeTags = this.copiedShape.write(new CompoundTag());
            tag.m_128365_("copiedShape", (Tag)copiedShapeTags);
        }
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            this.hasStashIfOne = this.copiedShape == null ? 0 : 1;
        }
    }

    public boolean isAvailable(StructCommands shape) {
        ItemStack stack = this.inventory.getStackInSlot(2);
        if (stack.m_41619_()) {
            return false;
        }
        boolean cardEmpty = stack.m_41783_() == null || !stack.m_41783_().m_128471_("cyclic-shape");
        BlockPos invA = this.getTarget(0);
        BlockPos invB = this.getTarget(1);
        boolean hasTargets = invA != null && invB != null;
        switch (shape) {
            case COPY: {
                return !cardEmpty;
            }
            case MERGE: {
                return !cardEmpty && this.hasStashIfOne == 1;
            }
            case PASTE: {
                return cardEmpty && this.hasStashIfOne == 1;
            }
            case READ: {
                return cardEmpty && hasTargets;
            }
        }
        return true;
    }

    public BlockPos getTarget(int s) {
        ItemStack stackA = this.inventory.getStackInSlot(s);
        BlockPosDim loc = LocationGpsCard.getPosition(stackA);
        return loc == null ? null : loc.getPos();
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case COMMAND: {
                return 0;
            }
            case RENDER: {
                return this.render;
            }
            case STASH: {
                return this.hasStashIfOne;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case STASH: {
                this.hasStashIfOne = value;
                break;
            }
            case COMMAND: {
                if (value >= StructCommands.values().length) {
                    value = 0;
                }
                StructCommands cmd = StructCommands.values()[value];
                this.execute(cmd);
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    static enum StructCommands {
        READ,
        COPY,
        MERGE,
        PASTE;

    }

    static enum Fields {
        RENDER,
        COMMAND,
        STASH;

    }
}

